/*-----------------------------------------------------------------
 * THIS CODE FOR DEMONSTRATION PURPOSES ONLY
 * RELEASED INTO THE PUBLIC DOMAIN
 *
 * Simple key acquisition patch for ROM version 2.0.300
 */
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>


#ifndef O_BINARY
#define O_BINARY 0
#endif

typedef unsigned char uchar;
typedef unsigned long int uint;
uchar buf[256];


int
main (int argc, char **argv)
{
  int fd;
  uint *b = (uint *) buf;

  if (argc < 2)
    exit (-1);
  fd = open (argv[1], O_BINARY | O_RDWR);
  if (fd < 0) {
    fprintf (stderr, "Unable to open \"%s\".\n", argv[1]);
    exit (-1);
  }
  if (lseek (fd, 0x7EF00, SEEK_SET) == -1) {
    fprintf (stderr, "Seek failed on \"%s\".\n", argv[1]);
    exit (-1);
  }
  if (read (fd, buf, 256) != 256) {
    fprintf (stderr, "Read failed on \"%s\".\n", argv[1]);
    exit (-1);
  }
  if (buf[0x14] != 0x02) {
    exit (14);
  }
  buf[0x14] = 0x4;
  if (b[0x28 / 4] != 0xe3a07003) {
    exit (28);
  }
  b[0x28 / 4] = 0xe59f7044;
  if (b[0x48 / 4] != 0x1a00000a) {
    exit (48);
  }
  b[0x48 / 4] = 0xe1a00000;
  if (b[0x54 / 4] != 0xe1a05000) {
    exit (54);
  }
  b[0x54 / 4] = 0xe3a05b04;
  if (b[0x58 / 4] != 0xe3750001) {
    exit (58);
  }
  b[0x58 / 4] = 0xe2877001;
  if (b[0x5C / 4] != 0x03a04075) {
    exit (12);
  }
  b[0x5C / 4] = 0xe35700ff;
  if (b[0x60 / 4] != 0x0a000004) {
    exit (60);
  }
  b[0x60 / 4] = 0x03a07000;
  if (b[0x64 / 4] != 0xe3550000) {
    exit (64);
  }
  b[0x64 / 4] = 0xe58f7008;
  if (b[0x68 / 4] != 0x03a04076) {
    exit (68);
  }
  b[0x68 / 4] = 0xe3540000;
  if (b[0x6C / 4] != 0xa000001) {
    exit (13);
  }
  b[0x6C / 4] = 0x1afffff1;
  if (b[0x70 / 4] != 0xe3550b02) {
    exit (70);
  }
  b[0x70 / 4] = 0xea000006;
  if (b[0x74 / 4] != 0x83a0405e) {
    exit (74);
  }
  b[0x74 / 4] = 0x0;
  if (buf[0x90] != 0x02) {
    exit (90);
  }
  buf[0x90] = 0x4;
  if (buf[0xAC] != 0x04) {
    exit (14);
  }
  buf[0xAC] = 0x0;
  if (lseek (fd, 0x7EF00, SEEK_SET) == -1) {
    fprintf (stderr, "Seek failed on \"%s\".\n", argv[1]);
    exit (-1);
  }
  if (write (fd, buf, 256) != 256) {
    fprintf (stderr, "write failed on \"%s\".\n", argv[1]);
    exit (-1);
  }
  printf ("KEYPATCH SUCCESS\n");
  exit (0);
}
