/** RBUNLOCK
 ** Written by Anonymous
 ** Released into the public domain
 **
 ** This program might be prohibitted in some countries. Use with caution.
 **
 ** Updates:
 **    Changed to use KEY# files instead of device1.key/user1.key
 **    New digest and magic stuff for RB ver 3
 **    Now reverts REB ver 3 back to ver 2.
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <sys/stat.h>

#include "libcrypt.h"
#include "blowfish.h"
#include "sha.h"


#ifndef O_BINARY
#define O_BINARY 0
#endif


#ifdef S_IREAD
#define PERM S_IREAD|S_IWRITE
#endif

#ifdef _S_IREAD
#undef PERM
#define PERM _S_IREAD|_S_IWRITE
#endif

#define BSWAP(x) \
   ((((x) >> 24) & 0xFF)|\
    (((x) >>  8) & 0xFF00)|\
    (((x) <<  8) & 0xFF0000)|\
    (((x) << 24) & 0xFF000000))

unsigned char buffer[4096];

unsigned char *
read_whole_file (char *fname, int *size)
{
  int fd, res;
  off_t length;
  void *ptr;

  *size = 0;
  fd = open (fname, O_RDONLY | O_BINARY);
  if (fd < 0) {
    perror ("open");
    fprintf (stderr, "Failed to open file: %s\n", fname);
    return NULL;		/* allow a retry */
  }
  length = lseek (fd, 0, SEEK_END);
  if ((length == -1) || (lseek (fd, 0, SEEK_SET) == -1)) {
    perror ("lseek");
    close (fd);
    exit (-1);
  }
  ptr = (unsigned char *) malloc (length);
  if (!ptr) {
    fprintf (stderr, "Unable to alloc %d bytes\n", length);
    close (fd);
    exit (-1);
  }
  res = read (fd, ptr, length);
  if (res != length) {
    if (res < 0) {
      perror ("read");
      free (ptr);
      close (fd);
      exit (-1);
    }
    else {
      fprintf (stderr, "Only read %d out of %d bytes for %s\n",
	       res, length, length);
      free (ptr);
      close (fd);
      exit (-1);
    }
  }
  *size = length;
  close (fd);
  return ptr;
}

unsigned char
nybble (char c)
{
  c |= 0x20;
  if ((c >= '0') && (c <= '9')) {
    c -= '0';
  }
  else if ((c >= 'a') && (c <= 'f')) {
    c = (c - 'a') + 10;
  }
  else {
    fprintf (stderr, "FAILURE - Bad hex data %02x in key5.\n", c);
    exit (-1);
  }
  return c;
}

EGPrivateKey *
ReadShortEGPrivateKey (unsigned char **buffer)
{
  EGPrivateKey *egkey;

  egkey = (EGPrivateKey *) malloc (sizeof (EGPrivateKey));
  egkey->p = bufGetBigInt (buffer);
  egkey->q = bufGetBigInt (buffer);
  egkey->alpha = bufGetBigInt (buffer);
  egkey->publicKey = bufGetBigInt (buffer);
  egkey->secret = bufGetBigInt (buffer);
  /* A short key doesn't have a table.  Table is only used for
   * encryption. I shall calculate it just in case.
   */
  egkey->g_table = g16_bigpow (egkey->alpha, egkey->p, 8 * LENGTH (egkey->q));

  return egkey;
}

void
next_line (char **ptr_to_ptr)
{
  char *p = *ptr_to_ptr;

  while (*p) {
    if ((*p == 0x0D) || (*p == 0x0A))
      break;
    p++;
  }
  while (*p) {
    if ((*p != 0x0D) && (*p != 0x0A))
      break;
    p++;
  }
  *ptr_to_ptr = p;
}

char *
find_name_in_index (char *name, int *len, char *index)
{
  int namelen;
  char *p;

  p = index;
  *len = 0;
  namelen = strlen (name);
  do {
    if (strncmp (p, name, namelen) == 0)
      if (*(p + namelen) == '=') {
	*len = p - index;
	return p;
      }
    next_line (&p);
  } while (*p);
  return NULL;
}

void
clear_entry (char *p)
{
  while (*p) {
    if ((*p == 0x0D) || (*p == 0x0A))
      break;
    *p = ' ';
    p++;
  }
}

char *taboo[] = { "COPYCERTREV", "EXPIRATION", "COPY_ID", "USERNAME" };

int
rectify_index (int fd, int ofd, int length)
{
  char *index_ptr;
  int bytes;
  char *newbody_ptr;
  int newbody_len;
  int i;


  index_ptr = (char *) malloc (length + 1);
  if (!index_ptr)
    return -1;

  *(index_ptr + length) = '\0';

  bytes = read (fd, index_ptr, length);
  if (bytes != length) {
    perror ("read");
    return -1;
  }
  newbody_ptr = find_name_in_index ("NEWBODY", &newbody_len, index_ptr);
  if (newbody_ptr) {
    int body_len;
    char *body_ptr;
    char *source, *dest;

    body_ptr = find_name_in_index ("BODY", &body_len, index_ptr);
    if (body_ptr)
      clear_entry (body_ptr);

    /* STRNCPY will not handle overlap.  Do it myself */
    source = newbody_ptr + 3;
    dest = newbody_ptr;
    while (*dest) {
      *(dest++) = *source;
      if ((*source == 0x0D) || (*source == 0x0A)) {
	*(dest) = *(source + 1);
	break;
      }

      source++;
    }
    dest = dest - 1;		/* start at beginning of newline */
    next_line (&dest);
    clear_entry (dest);
  }
  for (i = 0; i < (sizeof (taboo) / sizeof (taboo[0])); i++) {
    char *p;
    int len;

    p = find_name_in_index (taboo[i], &len, index_ptr);
    if (p)
      clear_entry (p);
  }

  bytes = write (ofd, index_ptr, length);
  if (bytes != length) {
    perror ("write");
    return -1;
  }
  return 0;
}

unsigned char ivec_source[8] =
  { 0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32, 0x10 };
unsigned char ivec_ver3[8] =
  { 0xf7, 0x4c, 0x64, 0x86, 0x49, 0xf8, 0x0c, 0x83 };

typedef struct __toc_entry
{
  unsigned char filename[32];
  unsigned long int length;
  unsigned long int offset;
  unsigned long int flags;
}
toc_entry;

unsigned char magic_array[8] =
  { 0x18, 0x8D, 0x8E, 0xBB, 0x55, 0x8C, 0xB8, 0x5D };

int
main (int argc, char **argv)
{
  int res;
  int size;

  unsigned char *cert_ptr;
  int cert_size;

  unsigned char *user_cert_ptr;
  int user_cert_size;

  unsigned char blowfish_key_data[16];
  SHA_CTX key_context;
  unsigned char hash_output[20];
  unsigned char device_id[8];
  unsigned char *p;

  BF_KEY cert_key;
  int bf_num;
  unsigned char ivec[8];

  unsigned int cert_data_size;
  unsigned long int cert_version;

  EGPrivateKey *eg_userkey;
  BigInt pkey;


  BigInt usercert_in, usercert_out;
  unsigned char blowfish_usercert_key[16];

  int fd;
  BigInt filekey_in, filekey_out;
  unsigned char blowfish_file_key[16];
  BF_KEY file_key;
  unsigned char mystery_data[8];

  unsigned char *newkey_file;
  int newkey_size;
  unsigned char newkey_array[16];


  off_t toc_offset;
  toc_entry *toc;
  int i, entries;

  int ofd;
  char *write_fname;
  int bytes;

  int rb_version;

  if (argc != 4) {
    fprintf (stderr, "Usage: rbunlock device-id bookfile outfile\n");
    exit (-1);
  }
  write_fname = argv[3];

  res = sscanf (argv[1], "%02x%02x%02x%02x%02x%02x%02x%02x",
		&device_id[0], &device_id[1], &device_id[2], &device_id[3],
		&device_id[4], &device_id[5], &device_id[6], &device_id[7]);
  if (res != 8) {
    fprintf (stderr, "Error parsing string \"%s\", result=%d\n", argv[1],
	     res);
    exit (-1);
  }

  fprintf (stderr, "A. READING DEVICE KEY (#0)\n");
  cert_ptr = read_whole_file ("key0", &cert_size);

  if (!cert_ptr)
    exit (-1);
  cert_version = BSWAP (*(unsigned long int *) (cert_ptr + 36));
  cert_data_size = BSWAP (*(unsigned long int *) (cert_ptr + 40));
  fprintf (stderr, "        Version = %lx, size = %lx\n",
	   cert_version, cert_data_size);

  SHA1_Init (&key_context);
  SHA1_Update (&key_context, device_id, sizeof (device_id));
  SHA1_Update (&key_context, cert_ptr + 4, 8);
  SHA1_Final (hash_output, &key_context);

  memcpy (blowfish_key_data, hash_output, 16);
  blowfish_key_data[0] ^= hash_output[16];
  blowfish_key_data[1] ^= hash_output[17];
  blowfish_key_data[2] ^= hash_output[18];
  blowfish_key_data[3] ^= hash_output[19];

  BF_set_key (&cert_key, sizeof (blowfish_key_data), blowfish_key_data);
  bf_num = 0;
  memcpy (ivec, ivec_source, sizeof (ivec));

  BF_cfb64_encrypt (cert_ptr + 44, cert_ptr + 44, cert_data_size, &cert_key,
		    ivec, &bf_num, BF_DECRYPT);

  if (*(unsigned long int *) (cert_ptr + 44) != 0x02010102) {
    fprintf (stderr, "FAILURE - Incorrect decryption for device key!\n");
    exit (-1);
  }

  fprintf (stderr, "B. READING DEVICE KEY (#2)\n");
  user_cert_ptr = read_whole_file ("key2", &user_cert_size);
  cert_version = BSWAP (*(unsigned long int *) (user_cert_ptr + 36));
  cert_data_size = BSWAP (*(unsigned long int *) (user_cert_ptr + 40));
  fprintf (stderr, "        Version = %lx, size = %lx\n",
	   cert_version, cert_data_size);

  bf_num = 0;
  memcpy (ivec, ivec_source, sizeof (ivec));

  BF_cfb64_encrypt (user_cert_ptr + 44, user_cert_ptr + 44,
		    cert_data_size + 20, &cert_key, ivec, &bf_num,
		    BF_DECRYPT);
  if (*(unsigned long int *) (user_cert_ptr + 44) != 0x02010102) {
    fprintf (stderr, "FAILURE - Incorrect decryption for user key!\n");
    exit (-1);
  }
  p = user_cert_ptr + 44;
  eg_userkey = ReadShortEGPrivateKey (&p);
  if (!eg_userkey) {
    fprintf (stderr, "Oh, come on.. the key read fucked up!\n");
    exit (-1);
  }
  {
    int len;

    len = p - user_cert_ptr;
    len -= 44;
    fprintf (stderr,
	     "        Processed %d (0x%lx) bytes of key data \n", len, len);
  }
  pkey = bigInit (0);
  bigPow (eg_userkey->alpha, eg_userkey->secret, eg_userkey->p, pkey);
  if (bigCompare (pkey, eg_userkey->publicKey) == 0) {
    fprintf (stderr, "        User key passes selfcheck.\n");
  }
  else {
    fprintf (stderr, "ERROR -- User key failed self-check!\n");
    exit (-1);
  }
  free (cert_ptr);
  free (user_cert_ptr);

  fprintf (stderr, "C. DECRYPTING THE RB FILE \n");

  fd = open (argv[2], O_RDONLY | O_BINARY);
  if (fd < 0) {
    perror ("open");
    fprintf (stderr, "Failed to open file: %s\n", argv[2]);
    freeEGPrivateKey (eg_userkey);
    exit (-1);
  }
  res = read (fd, buffer, 0x128);
  if (res != 0x128) {
    if (res < 0) {
      perror ("read");
      close (fd);
      freeEGPrivateKey (eg_userkey);
      exit (-1);
    }
    else {
      fprintf (stderr, "Only read %d out of %d bytes for %s\n",
	       res, 0x128, argv[3]);
      freeEGPrivateKey (eg_userkey);
      close (fd);
      exit (-1);
    }
  }
  filekey_in = bigInit (0);
  bufToBig (buffer + 32, LENGTH (eg_userkey->p) * 8, filekey_in);
  filekey_out = EGDecrypt (filekey_in, eg_userkey);
  bigToBuf (filekey_out, 16, blowfish_file_key);

  rb_version = *(buffer + 4);
  if (rb_version > 2) {
    /* Version 2 was a classic vintage.  Let us not lose it. */
    *(buffer + 4) = 2;

    fprintf (stderr, "D. READING FIRST NEW KEY (#5)\n");

    newkey_file = read_whole_file ("key5", &newkey_size);
    if (!newkey_file) {
      fprintf (stderr, "FAILURE - Couldn't read new key.\n");
      exit (-1);
    }
    for (i = 0; i < 8; i++) {
      char c;

      c = (nybble (newkey_file[(i * 2)]) << 4);
      c |= nybble (newkey_file[(i * 2) + 1]);
      newkey_array[i] = newkey_array[i + 8] = c;
    }
    free (newkey_file);


    fprintf (stderr, "E. READING SECOND NEW KEY (#6)\n");
    newkey_file = read_whole_file ("key6", &newkey_size);
    if (!newkey_file) {
      fprintf (stderr, "FAILURE - Couldn't read new key.\n");
      exit (-1);
    }
    for (i = 0; i < 16; i++) {
      newkey_array[i] ^= newkey_file[i];
    }
    free (newkey_file);

    for (i = 0; i < 16; i++) {
      blowfish_file_key[i] ^= newkey_array[i];
      blowfish_file_key[i] ^= magic_array[i & 7];
    }
  }

  BF_set_key (&file_key, sizeof (blowfish_file_key), blowfish_file_key);
  freeBignum (filekey_in);
  freeBignum (filekey_out);

  bf_num = 0;

  if (rb_version > 2) {
    memcpy (ivec, ivec_ver3, sizeof (ivec));
  }
  else {
    memcpy (ivec, ivec_source, sizeof (ivec));
  }

  p = buffer + 0x120;
  BF_cfb64_encrypt (p, mystery_data, 8, &file_key, ivec, &bf_num, BF_DECRYPT);

#if 1
  ofd = open (write_fname, O_BINARY | O_WRONLY | O_CREAT, PERM);
  if (ofd < 0) {
    perror ("open");
    fprintf (stderr, "Failed to open file: %s\n", write_fname);
    exit (-1);
  }
  memset (buffer + 0x20, 0, 0x108);
  res = write (ofd, buffer, 0x128);
  if (res != 0x128) {
    fprintf (stderr, "Failed to write %d bytes \n", 0x128);
    freeEGPrivateKey (eg_userkey);
    close (fd);
    close (ofd);
    unlink (write_fname);
    exit (-1);
  }

  toc_offset = *(unsigned long int *) &buffer[0x18];
  if (-1 == lseek (fd, toc_offset, SEEK_SET)) {
    perror ("lseek");
    freeEGPrivateKey (eg_userkey);
    close (fd);
    close (ofd);
    unlink (write_fname);
    exit (-1);
  }


  res = read (fd, buffer, 0x4);
  if (res != 4) {
    if (res < 0) {
      perror ("read");
      close (fd);
      freeEGPrivateKey (eg_userkey);
      close (ofd);
      unlink (write_fname);
      exit (-1);
    }
    else {
      fprintf (stderr, "Only read %d out of %d bytes for %s\n",
	       res, 4, argv[3]);
      freeEGPrivateKey (eg_userkey);
      close (fd);
      exit (-1);
    }
  }
  entries = *(unsigned long int *) &buffer[0];
  toc = (toc_entry *) malloc (entries * sizeof (toc_entry));
  if (!toc) {

    fprintf (stderr, "Unable to alloc %d bytes for %d entries\n",
	     sizeof (toc_entry) * entries, entries);
    freeEGPrivateKey (eg_userkey);
    close (fd);
    exit (-1);
  }

  res = read (fd, toc, entries * sizeof (toc_entry));
  if (res != entries * sizeof (toc_entry)) {
    if (res < 0) {
      perror ("read");
      close (fd);
      free (toc);
      freeEGPrivateKey (eg_userkey);
      exit (-1);
    }
    else {
      fprintf (stderr, "Only read %d out of %d bytes for %s\n",
	       res, entries * sizeof (toc_entry), argv[3]);
      freeEGPrivateKey (eg_userkey);
      free (toc);
      close (fd);
      exit (-1);
    }
  }

  for (i = 0; i < entries; i++) {

    printf ("%d  %32s %08lx %08lx %08lx \n",
	    i, toc[i].filename, toc[i].offset, toc[i].length, toc[i].flags);

    res = lseek (fd, toc[i].offset, SEEK_SET);
    if (res != -1) {
      res = lseek (ofd, toc[i].offset, SEEK_SET);
    }
    if (res == -1) {
      perror ("lseek");
      close (fd);
      close (ofd);
      free (toc);
      freeEGPrivateKey (eg_userkey);
      unlink (write_fname);
      exit (-1);
    }

    if (toc[i].flags & 2) {
      bytes = rectify_index (fd, ofd, toc[i].length);
      if (bytes != 0) {
	fprintf (stderr, "Doubleplusungood! Can't rectify index\n");
	close (ofd);
	close (ofd);
	free (toc);
	freeEGPrivateKey (eg_userkey);
	exit (-1);
      }
      continue;
    }

    if (rb_version > 2) {
      memcpy (ivec, ivec_ver3, sizeof (ivec));
    }
    else {
      memcpy (ivec, ivec_source, sizeof (ivec));
    }

    memcpy (ivec, ivec_ver3, sizeof (ivec));
    bytes = sizeof (buffer);
    while (bytes == sizeof (buffer)) {

      bytes = read (fd, buffer, sizeof (buffer));
      if (bytes < 0) {
	perror ("read");
	close (fd);
	close (ofd);
	free (toc);
	freeEGPrivateKey (eg_userkey);
	exit (-1);
      }
      if ((toc[i].flags & 1) || (toc[i].flags & 0x80)) {
	p = buffer;
	bf_num = 0;
	BF_cfb64_encrypt (p, p, bytes, &file_key, ivec, &bf_num, BF_DECRYPT);
      }
      res = write (ofd, buffer, bytes);
      if (res != bytes) {
	if (res < 0) {
	  perror ("write");
	}
	else {
	  fprintf (stderr, "Only wrote %d out of %d bytes\n", res, bytes);
	}
	close (fd);
	close (ofd);
	free (toc);
	freeEGPrivateKey (eg_userkey);
	exit (-1);
      }
    }
    toc[i].flags &= ~0x81;	/* not encrypted anymore, hehe */
  }

  if (-1 == lseek (ofd, toc_offset, SEEK_SET)) {
    perror ("lseek");
    freeEGPrivateKey (eg_userkey);
    close (fd);
    close (ofd);
    unlink (write_fname);
    exit (-1);
  }
  res = write (ofd, &entries, sizeof (entries));
  if (res == sizeof (entries)) {
    res = write (ofd, toc, entries * sizeof (toc_entry));
  }
  if (res != entries * sizeof (toc_entry)) {
    if (res < 0)
      perror ("write");
    else
      fprintf (stderr, "Error writing out TOC\n");
    freeEGPrivateKey (eg_userkey);
    close (fd);
    close (ofd);
    unlink (write_fname);
    exit (-1);
  }
  free (toc);
  close (fd);
  close (ofd);
  freeEGPrivateKey (eg_userkey);
#endif

  exit (0);
}
