/*
 RBTalk 1.0
 Modified from RBGet 1.0
 This program is hereby released into the Public Domain
 
 This code is a rapid port of a prototype Linux utility to
 interface with Gemstar's REB-1100 Ebook product.  
  
 This program has been modified for file sending as well.
*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <windows.h>
#include <setupapi.h>
#include <basetyps.h>
#include <initguid.h>

DEFINE_GUID (GUID_REB1100,
	     0x3bb1df43, 0xb2d4, 0x11d3,
	     0xbf, 0x85, 0x0, 0x10, 0x5a, 0x0a, 0x47, 0xb3);


/*
 IOCTL CODES
 222004 = RocketReadFile
 222008 = RocketWriteFile
 22200C = RocketWriteCodeSet
 222010 = RocketReadDebug
 222014 = RocketReadSerialNumber
 222018 = RocketReadInitiate
 22201C = RocketReadContinue
 222020 = RocketWriteInitiate
 222024 = RocketWriteContinue
 222028 = RocketSendCommand
 22202C = RocketWriteDebug
*/

unsigned char *buf;

char *valid = " $%-_@~`!{}()^#&.";
void
fix (char *s)
{
  char c;
  while (*s) {
    c = *(s++);
    if ((c >= 127) || ((c >= '0') && (c <= '9')) || ((c >= 'a') && (c <= 'z'))
	|| ((c >= 'A') && (c <= 'Z')) || (strchr (valid, c)))
      continue;
    *(s - 1) = '_';
  }
}

int
fakeread (HANDLE h, char *fname)
{
  int octets;
  long int total = 0;

  if (DeviceIoControl (h, 0x222018, fname, strlen (fname) + 1,
		       buf, 4096, &octets, NULL) < 0) {
    fprintf (stderr, "\nUNEXPECTED IOCTL ERROR #%d\n", GetLastError ());
    return -1;
  }
  if (!octets) {
    fprintf (stderr, "IOCTL RETURNED %d bytes \n", octets);
    return -1;
  }
  return 0;
}


int
getfile (HANDLE h, char *fname, int fd)
{
  int octets;
  long int total = 0;

  if (DeviceIoControl (h, 0x222018, fname, strlen (fname) + 1,
		       buf, 4096, &octets, NULL) < 0) {
    fprintf (stderr, "\nUNEXPECTED IOCTL ERROR #%d\n", GetLastError ());
    return -1;
  }
  if (!octets) {
    fprintf (stderr, "IOCTL RETURNED %d bytes \n", octets);
    return -1;
  }
  if (write (fd, buf, octets) != octets)
    return -1;
  total = octets;
  while (octets == 4096) {
    printf ("%d OCTETS READ.\r", total);
    if (DeviceIoControl (h, 0x22201C, NULL, 0, buf, 4096, &octets, NULL) < 0)
      return -1;
    if (write (fd, buf, octets) != octets)
      return -1;
    total += octets;
  }
  return 0;
}

/***************************************************************************
**
** Name: putfile
**
** In:
**       HANDLE h - This is the file handle for the REB device driver
**       char * remote_name - This is the name to use on the REB
**       int fd  - This is the file handle for the local file
**  Returns:
**       int  -1 for failure
**             0 for success
**  Notes:
**        Originally, I tried to send files buffer-by-buffer, like the
**        read logic.  That seems to fail for everything larger than one
**        buffer.  Currently, I'll read the whole file into memory and send
**        it 4096 by 4096.
**/
int
putfile (HANDLE h, char *remote_name, int fd)
{
  unsigned char *send_ptr;
  long int file_size, send_size;
  int octets;
  long int total = 0;
  int status;
  unsigned char *file_ptr;
  char *p;

  file_size = lseek (fd, 0, SEEK_END);
  lseek (fd, 0, SEEK_SET);
  fprintf (stderr, "Preparing to write %d bytes\n", file_size);
  if (file_size <= 0)
    return -1;

  send_size = file_size + strlen (remote_name) + 1;
  send_ptr = (unsigned char *) malloc (send_size);
  if (send_ptr == NULL) {
    fprintf (stderr, "Failed to allocate %d bytes for send buffer.\n");
    return -1;
  }

  strcpy (send_ptr, remote_name);
  p = send_ptr + strlen (remote_name);
  *(p++) = '\0';
  if ((octets = read (fd, p, file_size)) != file_size) {
    fprintf (stderr, "ERROR - Read %d bytes out of %d bytes\n", octets,
	     file_size);
    return -1;
  }
  p = send_ptr;
  if (DeviceIoControl (h, 0x222020, p, send_size, NULL, 0, &status, NULL) < 0) {
    fprintf (stderr, "\nUNEXPECTED IOCTL ERROR #%d\n", GetLastError ());
    free (send_ptr);
    return -1;
  }
  if (octets > 4096)
    octets = 4096;
  send_size -= octets + strlen (remote_name) + 1;
  p += octets + strlen (remote_name) + 1;

  while (send_size > 0) {
    octets = send_size;
    if (octets > 4096)
      octets = 4096;
    if (DeviceIoControl (h, 0x222024, p, octets, NULL, 0, &status, NULL) < 0) {
      free (send_ptr);
      return -1;
    }
    send_size -= octets;
    p += octets;
    printf ("%d OCTETS REMAINING.\r", send_size);
  }
  printf ("\nFILE SEND COMPLETED... \n");
  free (send_ptr);
  return 0;
}

int
putcode (HANDLE h, char *remote_name, int fd)
{
  unsigned char *send_ptr;
  long int file_size, send_size;
  int octets;
  long int total = 0;
  int status;
  unsigned char *file_ptr;
  char *p;

  file_size = lseek (fd, 0, SEEK_END);
  lseek (fd, 0, SEEK_SET);
  if (file_size <= 0)
    return -1;

  send_size = file_size + strlen (remote_name) + 1;
  send_ptr = (unsigned char *) malloc (send_size);
  if (send_ptr == NULL) {
    fprintf (stderr, "Failed to allocate %d bytes for send buffer.\n");
    return -1;
  }
  strcpy (send_ptr, remote_name);
  p = send_ptr + strlen (remote_name);
  *(p++) = '\0';
  if ((octets = read (fd, p, file_size)) != file_size) {
    fprintf (stderr, "ERROR - Read %d bytes out of %d bytes\n", octets,
	     file_size);
    return -1;
  }
  p = send_ptr;
  if (DeviceIoControl (h, 0x22200C, p, send_size, NULL, 0, &status, NULL) < 0) {
    fprintf (stderr, "\nUNEXPECTED IOCTL ERROR #%d\n", GetLastError ());
    free (send_ptr);
    return -1;
  }
  if (octets > 4096)
    octets = 4096;
  send_size -= octets + strlen (remote_name) + 1;
  p += octets + strlen (remote_name) + 1;

  while (send_size > 0) {
    octets = send_size;
    if (octets > 4096)
      octets = 4096;
    if (DeviceIoControl (h, 0x222024, p, octets, NULL, 0, &status, NULL) < 0) {
      free (send_ptr);
      return -1;
    }
    send_size -= octets;
    p += octets;
    printf ("%d OCTETS REMAINING.\r", send_size);
  }
  printf ("\nFILE SEND COMPLETED... \n");
  free (send_ptr);
  return 0;
}

int
command (HANDLE h, unsigned long int cmd)
{
  int status;
  int i;
  unsigned long int x[2];

  x[0] = 4;
  x[1] = cmd;

  if (DeviceIoControl (h, 0x222028, x, sizeof (x), buf, 4096,
		       &status, NULL) < 0) {
    fprintf (stderr, "\nUNEXPECTED IOCTL ERROR #%d\n", GetLastError ());
    return -1;
  }
  return 0;
}


int
main (int argc, char **argv)
{
  char rname[128 + 33], fname[33], sernum[0x32];
  HANDLE h;
  HDEVINFO hdi = NULL;
  int fd = 0, ofd = 0, i, len, newlen, b = 0, c = 0, r = 0;
  off_t tocpos;
  PSP_INTERFACE_DEVICE_DETAIL_DATA piddd;
  SP_INTERFACE_DEVICE_DATA sidd;

  fprintf (stderr, "rebtalk utility.  Release 1.2  \n");
  fprintf (stderr, "THIS PACKAGE IS IN THE PUBLIC DOMAIN AND UNSUPPORTED!\n");
  if (!(buf = malloc (4096 + 256)))
    goto abend;
  hdi = SetupDiGetClassDevs (&GUID_REB1100,
			     NULL, NULL,
			     DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
  sidd.cbSize = sizeof (SP_INTERFACE_DEVICE_DATA);
  if (!SetupDiEnumDeviceInterfaces (hdi, 0, &GUID_REB1100, 0, &sidd)) {
    if (GetLastError () != ERROR_NO_MORE_ITEMS)
      goto syserr;
    fprintf (stderr, "ERROR: UNABLE TO LOCATE REB-1100 UNIT\n");
    goto abend;
  }
  SetupDiGetInterfaceDeviceDetail (hdi, &sidd, NULL, 0, &len, NULL);
  if (!(piddd = malloc (len)))
    goto abend;
  piddd->cbSize = sizeof (SP_INTERFACE_DEVICE_DETAIL_DATA);
  if (!SetupDiGetInterfaceDeviceDetail (hdi, &sidd, piddd,
					len, &newlen, NULL)) goto syserr;
  printf ("LOCATED DEVICE AT: %s\n", piddd->DevicePath);
  h = CreateFile (piddd->DevicePath,
		  GENERIC_READ | GENERIC_WRITE,
		  FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0,
		  NULL);
  if (h == INVALID_HANDLE_VALUE)
    goto syserr;
  if (!DeviceIoControl (h, 0x222014, NULL, 0,
			sernum, sizeof (sernum), &newlen, NULL))
    goto syserr;
  fprintf (stderr, "REB-1100 SERIAL NUMBER IS: %.32s\n", sernum);
  if (argc < 3)
    exit (0);
  if (lstrcmpi (argv[1], "GET") == 0) {
    fd = 1;
    if (argc >= 4) {
      strncpy (fname, argv[3], sizeof (fname));

      fd = open (fname, O_BINARY | O_WRONLY | O_CREAT, S_IREAD | S_IWRITE);
      if (fd <= 0) {
	fprintf (stderr, "UNABLE TO OPEN FILE %s FOR WRITING\n", fname);
	perror ("FAILURE REASON:");
	goto abend;
      }
      c++;
    }
    if (getfile (h, argv[2], fd)) {
      fprintf (stderr, "UNABLE TO GET FILE FROM REB-1100\n");
      goto abend;
    }
    close (fd);
    fprintf (stderr, "GET SUCCESSFUL.\n");
  }
  else if (lstrcmpi (argv[1], "PUT") == 0) {
    if (argc < 4) {
      fprintf (stderr, "Fatal error -- No local name specified. \n");
      exit (100);
    }
    strncpy (fname, argv[3], sizeof (fname));
    fd = open (fname, O_BINARY | O_RDONLY);
    if (fd <= 0) {
      fprintf (stderr, "UNABLE TO OPEN FILE %s FOR READING\n", fname);
      perror ("FAILURE REASON:");
      goto abend;
    }
    c = 0;
    if (putfile (h, argv[2], fd)) {
      fprintf (stderr, "UNABLE TO SEND FILE TO REB-1100\n");
      goto abend;
    }
    close (fd);
    fprintf (stderr, "\nFILE PUT SUCCESSFUL\n");
  }
  else if (lstrcmpi (argv[1], "COMMAND") == 0) {
    i = atoi (argv[2]);
    if (command (h, i))
      goto abend;
  }
  else if (lstrcmpi (argv[1], "PUTCODE") == 0) {
    if (argc < 4) {
      fprintf (stderr, "Fatal error -- No local name specified. \n");
      exit (100);
    }
    strncpy (fname, argv[3], sizeof (fname));
    fd = open (fname, O_BINARY | O_RDONLY);
    if (fd <= 0) {
      fprintf (stderr, "UNABLE TO OPEN FILE %s FOR READING\n", fname);
      perror ("FAILURE REASON:");
      goto abend;
    }
    c = 0;
    if (putcode (h, argv[2], fd)) {
      fprintf (stderr, "UNABLE TO SEND CODE TO REB-1100\n");
      goto abend;
    }
    fprintf (stderr, "\nCODE PUT SUCCESSFUL\n");
    close (fd);
  }
  else if (lstrcmpi (argv[1], "EXTRACT") == 0) {
    if (_mkdir (argv[3])) {
      fprintf (stderr, "UNABLE TO CREATE DIR %s\n", argv[3]);
      perror ("FAILURE REASON:");
      goto abend;
    }
    _chdir (argv[3]);
    b++;
    strncpy (fname, argv[3], sizeof (fname) - 4);
    strcat (fname, ".rb");
    fd = open (fname, O_WRONLY | O_CREAT | O_BINARY, S_IREAD | S_IWRITE);
    if (fd <= 0) {
      fprintf (stderr, "UNABLE TO OPEN FILE %s FOR WRITING\n", fname);
      perror ("FAILURE REASON:");
      goto abend;
    }
    c++;
    if (getfile (h, argv[2], fd))
      goto abend;
    close (fd);
    c--;
    fd = open (fname, O_RDONLY | O_BINARY);
    if (fd <= 0) {
      fprintf (stderr, "UNABLE TO OPEN FILE %s FOR READING\n", fname);
      perror ("FAILURE REASON:");
      goto abend;
    }
    if (read (fd, buf, 0x128) != 0x128)
      goto syserr;
    tocpos = *(off_t *) & buf[0x18];
    lseek (fd, tocpos, 0);
    if (read (fd, buf, 4) != 4)
      goto syserr;
    i = *(int *) &buf[0];
    while (i--) {
      if (read (fd, buf, 44) != 44)
	goto syserr;
      printf ("FILE: %.32s  TYPE: %02x \n", &buf[0], buf[40]);
      strncpy (fname, buf, 32);
      strncpy (rname, argv[2], 128);
      strcat (rname, ":");
      strcat (rname, fname);
      fix (fname);
      printf ("   WRITING TO %s\n", fname);
      ofd = open (fname, O_WRONLY | O_CREAT | O_BINARY, S_IREAD | S_IWRITE);
      if (ofd <= 0) {
	fprintf (stderr, "UNABLE TO OPEN FILE %s FOR WRITING\n", fname);
	perror ("FAILURE REASON:");
	goto abend;
      }
      c++;
      if (getfile (h, rname, ofd))
	goto abend;
      close (ofd);
      c--;
    }
    close (fd);
    _chdir ("..");
    b--;
  }
  CloseHandle (h);
  SetupDiDestroyDeviceInfoList (hdi);
  free (buf);
  free (piddd);
  exit (0);
syserr:
  fprintf (stderr, "\nUNEXPECTED SYSTEM ERROR #%d\n", GetLastError ());
abend:
  if (b)
    _chdir ("..");
  if (fd)
    close (fd);
  if (ofd)
    close (ofd);
  if (c)
    unlink (fname);
  if (buf)
    free (buf);
  if (h != INVALID_HANDLE_VALUE)
    CloseHandle (h);
  if (hdi)
    SetupDiDestroyDeviceInfoList (hdi);
  if (piddd)
    free (piddd);
  exit (200);
}
